package com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsList;

public class FetchMygoalsListRequestHandler extends AbstractFetchPatientDataListRequestHandler<MygoalsDataLayer, MygoalsList, Mygoals> {

	@Override
	protected MygoalsList invokeDataLayerToFetchList(MygoalsDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.fetchMygoalsListByPatient(messageReader.getPatientIdentifier().getUniqueId());
	}

}
