package com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals;


import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsList;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;

public class FetchMostRecentMygoalsListRequestHandler extends AbstractFetchPatientDataListRequestHandler<MygoalsDataLayer, MygoalsList, Mygoals> {

	@Override
	protected MygoalsList invokeDataLayerToFetchList(MygoalsDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		PatientIdentifier patientIdentifier = messageReader.getPatientIdentifier();
		
		if (!patientIdentifier.getAssigningAuthority().equalsIgnoreCase("EDIPI")) {
			patientIdentifier = translatePatientIdentifier(patientIdentifier);
		}
		
		MygoalsList mostRecentMygoalsList = datalayer.fetchLatestMygoalsList(patientIdentifier.getUniqueId());
		
		return mostRecentMygoalsList;
	}
			
	private PatientIdentifier translatePatientIdentifier(PatientIdentifier patientIdentifier) {
		PatientIdentifiers correspondingIdentifiers = MhpObjectFactory.getInstance().getPatientCorrelationService().getCorrespondIdentifiers(patientIdentifier, "EDIPI");
		for(PatientIdentifier userIdentifier : correspondingIdentifiers) {
			return userIdentifier;
		}
				
		return patientIdentifier;
	}

}
