package com.agilex.healthcare.mobilehealthplatform.datalayer.mood;

import com.agilex.healthcare.mobilehealthplatform.datalayer.JournalEventsDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvents;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.restservice.exception.InvalidMoodException;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.validator.mood.MoodEventValidator;

public class MoodEventDataService extends JournalEventsDataService<MoodEvents, MoodEvent> {

	public MoodEventDataService(Router router) {
		super(router, Domain.moodevents, MoodEvents.class, new MoodEventValidator());
	}

	public MoodEventDataService() {
		this(new Router());
	}

	@Override
	protected void throwValidationException(ValidationResult<MoodEvent> validationResult) {
		throw new InvalidMoodException(validationResult.getErrors());
	}

}
