package com.agilex.healthcare.mobilehealthplatform.datalayer.mood;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvents;

public class FetchMoodListRequestHandler extends AbstractFetchPatientDataListRequestHandler<MoodEventDataLayer, MoodEvents, MoodEvent> {

	@Override
	protected MoodEvents invokeDataLayerToFetchList(MoodEventDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.getMoodEvents(messageReader.getPatientId(), messageReader.getDateFilter());
	}

}
