package com.agilex.healthcare.mobilehealthplatform.datalayer.metric;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class MetricThreadPoolListener implements ServletContextListener {

	private final static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MetricThreadPoolListener.class);
	private static ExecutorService pool;
	
	public static void execute(Runnable method) {
		pool.execute(method);
	}	
	
	@Override
	public void contextInitialized(ServletContextEvent sce) {
		logger.info("==> Listener is starting Metric Thread Pool");		
		pool = Executors.newFixedThreadPool(2);
	}

	@Override
	public void contextDestroyed(ServletContextEvent sce) {
		logger.info("==> Listener is stopping Metric Thread Pool");
		pool.shutdown();
	}

}
