package com.agilex.healthcare.mobilehealthplatform.datalayer.medication.rxrefill;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationRefillDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public class RefillMedicationRequestHandler implements RequestHandler {

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		MedicationRefillRequestReader requestReader = MedicationRefillRequestReader.fromRequest(requestMessage);
		MedicationRefillDataLayer dataLayer = getDataLayer(requestMessage);
		Medication medication = invokeDataLayer(dataLayer, requestReader);

		return MedicationRefillResponseBuilder.fromMedication(medication).build();
	}

	private MedicationRefillDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}

	Medication invokeDataLayer(MedicationRefillDataLayer dataLayer, MedicationRefillRequestReader requestReader) {
		return dataLayer.refillMedication(requestReader.getMedicationToRefill());
	}

}
