package com.agilex.healthcare.mobilehealthplatform.datalayer.medication.rxrefill;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;

public class MedicationRefillResponseBuilder {
	private ResponseMessage response;
	
	private MedicationRefillResponseBuilder(ResponseMessage response) {
		this.response = response;
	}
	
	public static MedicationRefillResponseBuilder getInstance() {
		return new MedicationRefillResponseBuilder(new ResponseMessage());
	}
	
	public static MedicationRefillResponseBuilder fromMedication(Medication medication) {
		ResponseMessage response = new ResponseMessage();
		MedicationRefillResponseBuilder builder = new MedicationRefillResponseBuilder(response);
		builder.setMedication(medication);
		
		return builder;
	}
	
	public static MedicationRefillResponseBuilder fromMedications(Medications medications) {
		ResponseMessage response = new ResponseMessage();
		MedicationRefillResponseBuilder builder = new MedicationRefillResponseBuilder(response);
		builder.appendDataItems(medications);
		
		return builder;
	}

	private MedicationRefillResponseBuilder setMedication(Medication medication) {
		response.setValue("medication", medication);
		return this;
	}
	
	public MedicationRefillResponseBuilder appendDataItems(Medications medications) {
		if(medications != null) {
			Medications existing = response.getValue("medications");
			if(existing == null) {
				response.setValue("medications", medications);
			} else {
				existing.addAll(medications);
			}
		}
		return this;
	}
	
	public ResponseMessage build() {
		return response;
	}
}
