package com.agilex.healthcare.mobilehealthplatform.datalayer.medication.rxrefill;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public class MedicationRefillRequestReader {
	protected RequestMessage request;
	
	protected MedicationRefillRequestReader(RequestMessage request) {
		this.request = request; 
	}
	
	public static MedicationRefillRequestReader fromRequest(RequestMessage request) {
		return new MedicationRefillRequestReader(request);
	}
	
	public void updatePatientIdentifer(PatientIdentifier patientIdentifier) {
		request.setValue("patient-identifier", patientIdentifier);
	}
	
	public PatientIdentifier getPatientIdentfier() {
		return request.getValue("patient-identifier");
	}
	
	public String getDomain() {
		return request.getValue("domain");
	}
	
	public Medication getMedicationToRefill() {
		return request.getValue("medication");
	}
}
