package com.agilex.healthcare.mobilehealthplatform.datalayer.medication.rxrefill;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class MedicationRefillRequestBuilder {
	protected RequestMessage request;
	
	protected MedicationRefillRequestBuilder(RequestMessage request) {
		this.request = request;
		request.setValue("scope-filter", ScopeFilter.getInstanceForLongitudinalScope());
	}
	
	public static MedicationRefillRequestBuilder forRefillMedication() {
		RequestMessage request = new RequestMessage();
		request.setType("RefillMedication");
		MedicationRefillRequestBuilder builder = new MedicationRefillRequestBuilder(request);
		return builder;
	}
	
	public static MedicationRefillRequestBuilder forFetchMedications() {
		RequestMessage request = new RequestMessage();
		request.setType("FetchRefillableMedications");
		MedicationRefillRequestBuilder builder = new MedicationRefillRequestBuilder(request);
		return builder;
	}
	
	public MedicationRefillRequestBuilder forPatientIdentifier(PatientIdentifier patientIdentifier) {
		request.setValue("patient-identifier", patientIdentifier);
		return this;
	}
	
	public MedicationRefillRequestBuilder forDomain(String domain) {
		request.setValue("domain", domain);
		return this;
	}
	
	public MedicationRefillRequestBuilder forMedication(Medication medication) {
		request.setValue("medication", medication);
		return this;
	}
	
	public RequestMessage build() {
		return request;
	}
}
