package com.agilex.healthcare.mobilehealthplatform.datalayer.medication;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;

public class MedicationFetchRequestBuilder extends PatientDataFetchRequestBuilder {
	private MedicationFetchRequestBuilder(RequestMessage request) {
		super(request);
	}

	public static MedicationFetchRequestBuilder forRetrieveList() {
		RequestMessage request = new RequestMessage();
		MedicationFetchRequestBuilder builder = new MedicationFetchRequestBuilder(request);
		request.setType("FetchListOfPatientData");
		return builder;
	}

	public static MedicationFetchRequestBuilder forRetrieveSingleById() {
		RequestMessage request = new RequestMessage();
		MedicationFetchRequestBuilder builder = new MedicationFetchRequestBuilder(request);
		request.setType("FetchPatientDataById");
		return builder;
	}

	public PatientDataFetchRequestBuilder forMedicationFilter(MedicationFilter medicationFilter) {
		request.setValue("medication-filter", medicationFilter);
		return this;
	}

}
