package com.agilex.healthcare.mobilehealthplatform.datalayer.medication;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityCache;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.PatientIdentifierHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.vamf.cdw.medication.CdwMedicationDataLayer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Collections;

public class MedicationDataService {

	private Router router;
	private CdwMedicationDataLayer layer;
	
    private static final Log logger = LogFactory.getLog(MedicationFilterer.class);

    public MedicationDataService() {
		this.router = new Router();
		layer = MhpObjectFactory.getInstance().getCdwMedicationDataLayer();
	}

	public MedicationDataService(Router router) {
		this.router = router;
		layer = MhpObjectFactory.getInstance().getCdwMedicationDataLayer();
	}

	public Medications getActivePatientMedications(PatientIdentifier patientIdentifier, MedicationFilter filter, ScopeFilter scopeFilter) {
		filter.addActiveStatus(true);
		Medications medications = fetchPatientMedications(patientIdentifier, filter, scopeFilter);

		return medications;
	}
	
	public Medications getActiveAndRecentlyExpiredPatientMedications(PatientIdentifier patientIdentifier, MedicationFilter filter, ScopeFilter scopeFilter) {
		filter.addMedicationSources(MedicationFilter.OUTPATIENT);
		
		Medications medications = getPatientMedicationHistory(patientIdentifier, filter, scopeFilter);

		return medications;
	}
	
	public Medications getPatientMedicationHistory(PatientIdentifier patientIdentifier, MedicationFilter filter, ScopeFilter scopeFilter) {
		filter.addStatus(MedicationFilter.STATUS_ACTIVE);
		filter.addStatus(MedicationFilter.STATUS_EXPIRED);
		
		Medications medications = fetchPatientMedications(patientIdentifier, filter, scopeFilter);

        return medications;
	}

	public Medications fetchPatientMedications(PatientIdentifier patientIdentifier, MedicationFilter filter, ScopeFilter scopeFilter) {
		/*RequestMessage request = MedicationFetchRequestBuilder.forRetrieveList().forMedicationFilter(filter).forDomain(Domain.medication).forPatientIdentifier(patientIdentifier).forScopeFilter(scopeFilter).build();
		ResponseMessage response = router.execute(request);
		Medications medications = PatientDataResponseReader.<Medications, Medication> fromResponse(response).getDataListNoNull(Medications.class);*/
		PatientIdentifiers icnPatientIdentifiers = PatientIdentifierHelper.translatePatientIdentifier(patientIdentifier, "ICN");
		if(NullChecker.isNullish(icnPatientIdentifiers))
			return new Medications();
		Medications medications = layer.getMedications(icnPatientIdentifiers.get(0), filter);
		PatientIdentifierHelper.updatePatientIdentifier(medications, patientIdentifier);
        medications = MedicationFilterer.filter(medications, filter);
        Collections.sort(medications);
		
		convertFacility(medications);
		return medications;
	}

	public Medication retrieveMedicationDetail(PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveSingleById().forDomain(Domain.medication).forPatientIdentifier(patientIdentifier).forDataIdentifier(dataIdentifier).build();
		ResponseMessage responseMessage = router.execute(request);
		Medication medication = PatientDataResponseReader.<Medications, Medication> fromResponse(responseMessage).getDataItem();
		convertFacility(medication);
		return medication;
	}
	
	private void convertFacility(Medication result) {
		String facilityName = FacilityCache.getInstance().getFacilityName(result.getSourceSystem());
		result.setSourceSystem(facilityName);
	}
	
	private void convertFacility(Medications results) {
		for (Medication result : results) {
			convertFacility(result);
		}
	}

}
