package com.agilex.healthcare.mobilehealthplatform.datalayer.medication;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class FetchMedicationRequestHandler extends AbstractFetchPatientDataRequestHandler<MedicationDataLayer, Medication> {

	@Override
	protected Medication invokeDataLayerToFetchSingleItem(MedicationDataLayer datalayer, PatientIdentifier patientIdentifier, String dataId, RequestMessage requestMessage) {
		return datalayer.getMedicationDetail(patientIdentifier, dataId);
	}

}
