package com.agilex.healthcare.mobilehealthplatform.datalayer.medication;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;

public class FetchMedicationListRequestHandler extends AbstractFetchPatientDataListRequestHandler<MedicationDataLayer, Medications, Medication> {

	@Override
	protected Medications invokeDataLayerToFetchList(MedicationDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		MedicationFetchRequestReader medicationFetchRequestReader = new MedicationFetchRequestReader(requestMessage);
		return datalayer.getMedications(medicationFetchRequestReader.getPatientIdentifier(), medicationFetchRequestReader.getMedicationFilter());
	}

}
