package com.agilex.healthcare.mobilehealthplatform.datalayer.learn;

import com.agilex.healthcare.mobilehealthplatform.domain.LearnArticle;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategory;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCondition;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnConditions;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ServiceRegistry;

public class LearnDataService {
	private LearnDataLayer datalayer;

	public LearnDataService() {
		datalayer = ServiceRegistry.getInstance().getPrimaryCommunity().getDataLayerFactory().getLearnDataLayer();
	}

	public LearnConditions fetchLearnConditions() {
		return datalayer.fetchLearnConditions();
	}

	public LearnCategories fetchLearnCategories(LearnCondition condition) {
		return datalayer.fetchLearnCategories(condition);
	}

	public LearnCategory fetchLearnCategory(String categoryId) {
		return datalayer.fetchLearnCategory(categoryId);
	}

	public LearnArticle fetchLearnArticle(String articleId) {
		return datalayer.fetchLearnArticle(articleId);
	}
}