package com.agilex.healthcare.mobilehealthplatform.datalayer.launchpad;

import java.util.Collections;

import com.agilex.healthcare.mobilehealthplatform.domain.LaunchpadItem;
import com.agilex.healthcare.mobilehealthplatform.domain.LaunchpadItems;
import com.agilex.healthcare.mobilehealthplatform.domain.LaunchpadMetadata;
import com.agilex.healthcare.mobilehealthplatform.enumeration.RunningMode;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.utility.NullChecker;

public class LaunchpadDataService {
	
	private LaunchpadItemDataLayer datalayer = null;
	
	public LaunchpadDataService() {
		datalayer = MhpObjectFactory.getInstance().getLaunchpadItemDataLayer();	
	}
	

	public LaunchpadMetadata fetchLaunchpadMetadata(String haMode) {
		RunningMode mode = null;
		if (NullChecker.isNotNullish(haMode)) {
			mode = RunningMode.valueOf(haMode.toUpperCase());
		}
		
		LaunchpadItems items = datalayer.fetchLaunchpadItems(mode);
		Collections.sort(items);
		LaunchpadMetadata metadata = new LaunchpadMetadata();
		metadata.setItem(items);
		
		return metadata;
	}
	
	public LaunchpadItems fetchLaunchpadItems(RunningMode mode) {
		return datalayer.fetchLaunchpadItems(mode);
	}
	
	public LaunchpadItem fetchLaunchpadItemByUrl(String haMode, String url) {
		RunningMode mode = null;
		if (NullChecker.isNotNullish(haMode)) {
			mode = RunningMode.valueOf(haMode.toUpperCase());
		}
		return datalayer.fetchLaunchpadItemByUrl(mode, url);
	}
}
