package com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroup;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;

public class MicrobiologyLabGrouper {

	public MicrobiologyLabGrouper() {}
	
	public LabTestGroups groupAndSort(LabTests labTests) {
		Map<String, LabTests> mappedLabTests = new HashMap<String, LabTests>();
		
		for(LabTest labTest : labTests) {
			String key = labTest.getDisplayName();
			LabTests tests = mappedLabTests.get(key);
			if(tests == null)
				mappedLabTests.put(key, newGroup(labTest));
			else
				addToExisting(tests, labTest);
		}
		
		return flattenAndSort(mappedLabTests);
	}
	
	private LabTestGroups flattenAndSort(Map<String, LabTests> mappedLabTests) {
		LabTestGroups groups = new LabTestGroups();
		
		for(String key : mappedLabTests.keySet()) {
			LabTests tests = mappedLabTests.get(key);
			Collections.sort(tests);
			LabTestGroup group = new LabTestGroup(key, tests);
			groups.add(group);
		}
		
		return groups;
	}
	
	private LabTests newGroup(LabTest labTest) {
		return new LabTests(labTest);
	}
	
	private void addToExisting(LabTests labTests, LabTest labTest) {
		labTests.add(labTest);
	}
}
