package com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.LabDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;

public class FetchLabRequestHandler extends AbstractFetchPatientDataListRequestHandler<LabDataLayer, LabResults, LabResult> {

	@Override
	protected LabResults invokeDataLayerToFetchList(LabDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.getLabResults(messageReader.getPatientIdentifier(), messageReader.getDateFilter());
	}

}
