package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import java.util.HashMap;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;

public class LabTestFilterByMostRecentResult {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(LabTestFilterByMostRecentResult.class);

	public HashMap<String, LabResult> getMostRecentResultsByTest(LabResults results) {
		
		HashMap<String, LabResult> labTestHistory = new HashMap<String, LabResult>();
		
		if (results != null) {

			logger.debug(String.format("Brute force method to getting list of lab tests for patient, parsing through all %s result(s) for patient.", results.size()));

			for (LabResult result : results) {

				String testId = result.getGroupingId();
				
				LabResult existingResult = labTestHistory.get(testId);

				if (existingResult == null) { 
					labTestHistory.put(testId, result);
				} else if (result.getResultedDate().compareTo(existingResult.getResultedDate()) > 0) { 
					labTestHistory.put(testId, result);
				} else {
				}
			}

		}
		return labTestHistory;
	}
}
