package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import java.util.Comparator;

import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;
import com.agilex.healthcare.utility.NullChecker;

public class LabTestComparatorByName implements Comparator<LabTest> {

	private static final int equals = 0;

	@Override
	public int compare(LabTest labTest1, LabTest labTest2) {
		int result = labTest1.getTestname().compareTo(labTest2.getTestname());
		if (result == equals && NullChecker.isNotNullish(labTest1.getSpecimenName()) && NullChecker.isNotNullish(labTest2.getSpecimenName()))
			result = labTest1.getSpecimenName().compareTo(labTest2.getSpecimenName());
		return result;
	}
}
