package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.utility.NullChecker;

public class LabResultsFilterByOrderNumber {
	private LabResultsFilterByOrderNumber() { }
	
	public static LabResults filter(LabResults results, String orderId) {
		LabResults newResults;
		if (NullChecker.isNotNullish(orderId)) {
			newResults = new LabResults();
			for (LabResult result : results) {
				if (result.getOrderId().contentEquals(orderId))
					newResults.add(result);
			}
		} else {
			newResults = results;
		}
		return newResults;
	}
}
