package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.utility.NullChecker;

public class LabResultsFilter {
	
	public LabResults filter(LabResults results, String groupingId) {
		if(NullChecker.isNullish(groupingId))
			return results;
		
		LabResults filtered = new LabResults();
		for(LabResult result : results) {
			if(groupingId.equals(result.getGroupingId())) {
				filtered.add(result);
			}
		}
		
		return filtered;
	}

	public static LabResults filter(LabResults results, String testId, String specimenId) {

		LabResults newResults = new LabResults();

		if (NullChecker.isNotNullish(testId) && NullChecker.isNotNullish(specimenId)) {
			for (LabResult result : results) {

				if (NullChecker.isNotNullish(result.getTestId()) && result.getTestId().contentEquals(testId) && NullChecker.isNotNullish(result.getSpecimenId())
						&& result.getSpecimenId().contentEquals(specimenId))
					newResults.add(result);
			}
		} else if (NullChecker.isNotNullish(testId)) {
			for (LabResult result : results) {
				if (result.getTestId().contentEquals(testId))
					newResults.add(result);
			}
		} else {
			newResults.addAll(results);
		}
		return newResults;
	}
}
