package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.utility.NullChecker;

public class LabResultOrganizer {

	public LabTests groupByTest(LabResults labResults) {

		Map<String, LabResults> resultsByTestAndSpecimenId = indexResultsByTestAndSpecimenId(labResults);

		LabTests labTests = createLabTests(resultsByTestAndSpecimenId);

		sortTestsByName(labTests);
		sortResults(labTests);

		return labTests;
	}

	private void sortTestsByName(LabTests labTests) {
		Collections.sort(labTests, new LabTestComparatorByName());
	}

	private void sortResults(LabTests labTests) {
		// LabResults labResults;

		for (LabTest labTest : labTests) {
			LabResults labResults = labTest.getLabResults();
			// List<LabResult> labResults = new ArrayList<LabResult>();
			// labResults.addAll(labTest.getLabResults());
			Collections.sort(labResults, new ComparatorByDate());
		}
	}

	private LabTests createLabTests(Map<String, LabResults> resultsByLabId) {
		LabTests labTests = new LabTests();
		for (String key : resultsByLabId.keySet()) {
			LabTest labTest = new LabTest();

			LabResults labResultsForThisTest = resultsByLabId.get(key);
			for (LabResult labResult : labResultsForThisTest) {
				fillInDataOnLabTest(labTest, labResult);
				labTest.getLabResults().add(labResult);
			}
			labTests.add(labTest);
		}
		return labTests;
	}

	private void fillInDataOnLabTest(LabTest labTest, LabResult labResult) {
		if (NullChecker.isNotNullish(labResult.getTestId()))
			labTest.setUniqueId(labResult.getTestId());

		if (NullChecker.isNotNullish(labResult.getTestname()))
			labTest.setTestname(labResult.getTestname());

		if (NullChecker.isNullish(labTest.getTestname()))
			labTest.setTestname(labTest.getUniqueId());

		if (NullChecker.isNotNullish(labResult.getSpecimenId()))
			labTest.setSpecimenId(labResult.getSpecimenId());

		if (NullChecker.isNotNullish(labResult.getSpecimenName()))
			labTest.setSpecimenName(labResult.getSpecimenName());

		if (NullChecker.isNotNullish(labResult.getDisplayDescription())) {
			labTest.setTestDescription(labResult.getDisplayDescription());
		}
	}

	private Map<String, LabResults> indexResultsByTestAndSpecimenId(LabResults labResults) {
		LabResults labResultsForTest = null;
		Map<String, LabResults> resultsByLabId = new HashMap<String, LabResults>();

		for (LabResult labResult : labResults) {
			String key = createKey(labResult);
			labResultsForTest = resultsByLabId.get(key);
			if (labResultsForTest == null) {
				labResultsForTest = new LabResults();
				resultsByLabId.put(key, labResultsForTest);
			}
			labResultsForTest.add(labResult);
		}

		return resultsByLabId;
	}

	private String createKey(LabResult labResult) {
		String key = labResult.getTestId() + ";" + labResult.getSpecimenId();
		return key;
	}

}
