package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import java.util.Comparator;
import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.utility.NullChecker;

public class ComparatorByDate implements Comparator<LabResult> {

	private static final int equals = 0;
	private static final int before = 1;
	private static final int after = -1;

	@Override
	public int compare(LabResult labResult1, LabResult labResult2) {
		Date labResultDate1 = labResult1.getResultedDate();
		Date labResultDate2 = labResult2.getResultedDate();

		if (NullChecker.isNullish(labResultDate1) && NullChecker.isNullish(labResultDate2))
			return equals;
		if (NullChecker.isNullish(labResultDate1) && NullChecker.isNotNullish(labResultDate2))
			return after;
		if (NullChecker.isNotNullish(labResultDate1) && NullChecker.isNullish(labResultDate2))
			return before;

		// multiply by -1 to reverse the natural order
		return -1 * labResult1.getResultedDate().compareTo(labResult2.getResultedDate());
	}

}