package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import java.util.Calendar;
import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterImpl;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.MutableDateFilter;
import com.agilex.healthcare.utility.NullChecker;

public abstract class AbstractLabDataService {

	protected void calculateResultAbnormalityFlag(LabResults newResults) {
		AbnormalityFlagCalculator calculator = new AbnormalityFlagCalculator();
		calculator.calculateAndUpdateResultAbnormalityFlag(newResults);
	}

	protected void determineDisplayName(LabResults labResults) {
		for (LabResult labResult : labResults) {
			String displayName = null;
			if (NullChecker.isNotNullish(labResult.getTestname()) && NullChecker.isNotNullish(labResult.getSpecimenName())) {
				displayName = String.format("%s (%s)", labResult.getTestname(), labResult.getSpecimenName());
			} else if (NullChecker.isNotNullish(labResult.getTestname()) && NullChecker.isNullish(labResult.getSpecimenName())) {
				displayName = labResult.getTestname();
			} else if (NullChecker.isNullish(labResult.getTestname()) && NullChecker.isNotNullish(labResult.getSpecimenName())) {
				displayName = labResult.getSpecimenName();
			}

			labResult.setDisplayName(displayName);
		}
	}

	public DateFilter getDefaultDateFilter() {
		MutableDateFilter result = new DateFilterImpl();
		result.setStartDate(getDefaultStartDate());
		result.setEndDate(getDefaultEndDate());
		return result;
	}
	
	public Date getDefaultStartDate() {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.YEAR, -15);
		return cal.getTime();
	}

	public Date getDefaultEndDate() {
		return new Date();
	}

	public LabTestGroups extractAndSortLabGroupsByLabTests(LabTests labTests) {
		ChemistryLabGrouper grouper = new  ChemistryLabGrouper();
		return grouper.group(labTests);
	}
}
