package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.utility.IsNumericCalculator;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.TriState;

public class AbnormalityFlagCalculator {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(AbnormalityFlagCalculator.class);

	public void calculateAndUpdateResultAbnormalityFlag(LabResults results) {
		if (results != null) {
			for (LabResult result : results) {
				calculateAndUpdateResultAbnormalityFlag(result);
			}
		}
	}

	private void calculateAndUpdateResultAbnormalityFlag(LabResult result) {
		result.setAbnormalIndicatorFlag(calculateResultAbnormalityFlag(result.getIndicator()));

		TriState abnormalIndicatorTriFlag = null;
		if (result.isAbnormalIndicatorFlag()) {
			abnormalIndicatorTriFlag = TriState.TRUE;
		} else {
			if (IsNumericCalculator.isNumeric(result.getValue()) && IsNumericCalculator.isNumeric(result.getReferenceHigh()) && IsNumericCalculator.isNumeric(result.getReferenceLow())) {
				abnormalIndicatorTriFlag = TriState.FALSE;
			} else {
				abnormalIndicatorTriFlag = TriState.UNKNOWN;
			}
		}
		result.setAbnormalIndicatorTriFlag(abnormalIndicatorTriFlag);
		//logger.debug(String.format("calculated abnormality [indicator=%s][value=%s][highref=%s][lowref=%s][abnormalflag=%s][abnormaltriflag=%s]", result.getIndicator(), result.getValue(),
		//		result.getReferenceHigh(), result.getReferenceLow(), result.isAbnormalIndicatorFlag(), result.getAbnormalIndicatorTriFlag()));
	}

	private boolean calculateResultAbnormalityFlag(String indicator) {
		if (NullChecker.isNullish(indicator)) {
			return false;
		} else if (indicator.toLowerCase().contentEquals("normal")) {
			return false;
		} else {
			return true;
		}
	}

}
