package com.agilex.healthcare.mobilehealthplatform.datalayer.healthadvocaterequest;

import java.util.Comparator;

import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequest;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateStatusCode;

public class HealthAdvocateRequestSortByStatusAndLastActionDateComparator implements Comparator<HealthAdvocateRequest> {

	@Override
	public int compare(HealthAdvocateRequest request1, HealthAdvocateRequest request2) {
		int c;
		int SortAdjustmentForDescending = -1;

		c = translateStatusOrdering(request1.getStatus()).compareTo(translateStatusOrdering(request2.getStatus()));
		
		if (c==0) {
			c = request1.getLastActionDate().compareTo(request2.getLastActionDate()) * SortAdjustmentForDescending;
		}
		
		return c;
	}

	private Integer translateStatusOrdering (String status) {
		Integer statusOrder = 6;

		if (HealthAdvocateStatusCode.SUBMITTED.equalsIgnoreCase(status)) {
			statusOrder = 1;
		} else if (HealthAdvocateStatusCode.ACCEPTED.equalsIgnoreCase(status)) {
			statusOrder = 2;
		} else if (HealthAdvocateStatusCode.DECLINED.equalsIgnoreCase(status)) {
			statusOrder = 3;
		} else if (HealthAdvocateStatusCode.CANCELLED.equalsIgnoreCase(status)){
			statusOrder = 4;
		} else if (HealthAdvocateStatusCode.REVOKED.equalsIgnoreCase(status)) {
			statusOrder = 5;
		}
		return statusOrder;
	}
}
