package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public class FetchFacilitiesRequestHandler implements RequestHandler {

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		FacilityRequestReader reader = FacilityRequestReader.fromRequest(requestMessage);
		FacilityDataLayer dataLayer = getDataLayer(requestMessage);
		Facilities facilities = invokeDataLayer(dataLayer, requestMessage, reader);
		
		return FacilityResponseBuilder.fromFacilities(facilities).build();
	}
	
	private FacilityDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
	
	private Facilities invokeDataLayer(FacilityDataLayer dataLayer, RequestMessage requestMessage, FacilityRequestReader requestReader) {
		FacilityFilter filter = requestReader.getFilter();
		return dataLayer.fetchFacilities(filter);
	}
}
