package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;

public class FacilityResponseBuilder {
	private ResponseMessage response;
	
	private FacilityResponseBuilder(ResponseMessage response) {
		this.response = response;
	}
	
	public static FacilityResponseBuilder fromFacilities(Facilities facilities) {
		ResponseMessage response = new ResponseMessage();
		FacilityResponseBuilder builder = new FacilityResponseBuilder(response);
		builder.appendFacilities(facilities);
		
		return builder;
	}
	
	public FacilityResponseBuilder appendFacilities(Facilities facilities) {
		if(facilities != null) {
			Facilities existing = response.getValue("facilities");
			if(existing == null) {
				response.setValue("facilities", facilities);
			} else {
				existing.addAll(facilities);
			}
		}
		return this;
	}
	
	public ResponseMessage build() {
		return this.response;
	}
}
