package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class FacilityRequestBuilder {
	protected RequestMessage request;
	
	protected FacilityRequestBuilder(RequestMessage request) {
		this.request = request;
		request.setValue("scope-filter", ScopeFilter.getInstanceForLongitudinalScope());
		request.setValue("domain", Domain.facility);
	}
	
	public static FacilityRequestBuilder forFacilities() {
		RequestMessage request = new RequestMessage();
		request.setType("FetchFacilities");
		FacilityRequestBuilder builder = new FacilityRequestBuilder(request);
		return builder;
	}
	
	public FacilityRequestBuilder forFilter(FacilityFilter filter) {
		request.setValue("facility-filter", filter);
		return this;
	}
	
	public RequestMessage build() {
		return this.request;
	}
}
