package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import java.util.List;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.vamf.cdw.facilities.CdwFacilityDataLayer;

public class FacilityDataService {

	private Router router;
	private CdwFacilityDataLayer layer;

	public FacilityDataService() {
		router = new Router();
		layer = MhpObjectFactory.getInstance().getCdwFacilityDataLayer();
	}
	
	public FacilityDataService(Router router) {
		this.router = router;
		layer = MhpObjectFactory.getInstance().getCdwFacilityDataLayer();
	}
	
	public Facilities fetchFacilities(FacilityFilter facilityFilter) {
		return fetchFacilities(facilityFilter,true);
	}
		
	public Facilities fetchFacilities(FacilityFilter facilityFilter, boolean useCache) {
		//RequestMessage request = FacilityRequestBuilder.forFacilities().forFilter(facilityFilter).build();
		
		Facilities facilities = null;
		if (useCache) {
			facilities = FacilityCache.getInstance().getFacilities(facilityFilter);
			if (facilities == null) {
				//facilities = getFacilitiesFromRouter(request);
				facilities = layer.fetchFacilities(facilityFilter);
				FacilityCache.getInstance().addFacilitiesToCache(facilityFilter,facilities);
			}
		} else {
			facilities = layer.fetchFacilities(facilityFilter);
			//facilities = getFacilitiesFromRouter(request);
		}
		return facilities;
	}
		
	/*private Facilities getFacilitiesFromRouter(RequestMessage request) {
		ResponseMessage responseMessage = router.execute(request);
		return FacilityResponseReader.fromResponse(responseMessage).getFacilities();
	}*/
		
	public Facility fetchFacilityByCode(List<String> pilotSites, String code) {
		return fetchIndividualFacility(pilotSites, code, null);
	}

	
	public Facility fetchFacilityByName(List<String> pilotSites, String name) {
		return fetchIndividualFacility(pilotSites, null, name);
	}

	
	private Facility fetchIndividualFacility(List<String> pilotSites, String code, String name) {
		FacilityFilterFactory facilityFilterFactory = new FacilityFilterFactory(pilotSites);
		FacilityFilter filter = facilityFilterFactory.createEmptyFacilityFilter();
		if (NullChecker.isNotNullish(code)) {
			filter.addFacilityCode(code);
		}
		if (NullChecker.isNotNullish(name)) {
			filter.setFacilityName(name);
		}
		Facilities facilities = fetchFacilities(filter);
		if (facilities.size() == 0) {
			throw new WebApplicationException(Status.NOT_FOUND);
		} else if (facilities.size() > 1) {
			throw new WebApplicationException(Status.PRECONDITION_FAILED);
		}
		
		return facilities.get(0);
	}
}
