package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;

public class FacilityCache {
	private Map<Integer, Facilities> facilityObjMap;
	private Map<String, String> facilityNameMap;
	private static FacilityCache instance;
	
	public static FacilityCache getInstance() {
		if (instance==null)
			instance = new FacilityCache();
		return instance;
	}
	
	private FacilityCache() {
		facilityObjMap = new ConcurrentHashMap<Integer, Facilities>();
		facilityNameMap = new ConcurrentHashMap<String, String>();
		init();
	}
	
	public void init() {
		try {
			FacilityFilterFactory facilityFilterFactory = new FacilityFilterFactory(null);
			FacilityFilter filter = facilityFilterFactory.createEmptyFacilityFilter();
			FacilityDataService facilityDataService = new FacilityDataService();
			Facilities facilities = facilityDataService.fetchFacilities(filter, false);
			addFacilitiesToCache(filter,facilities);
		} catch (Throwable t) { 
			// happens in test code when facility service is not ready
		}
	}

	public void addFacilitiesToCache(FacilityFilter filter, Facilities facilities) {
		if (filter!=null && facilities!=null) {
			facilityObjMap.put(filter.getKeyForCache(), facilities);
			for (Facility facility : facilities) {
				facilityNameMap.put(facility.getFacilityCode(), facility.getName());
			}
		}
	}
	
	public Facilities getFacilities(FacilityFilter filter) {
		if (filter==null)
			return null;
		return facilityObjMap.get(filter.getKeyForCache());
	}
	
	public String getFacilityName(String facilityCode) {
		if (facilityCode!=null && facilityNameMap.containsKey(facilityCode)) {
			return facilityNameMap.get(facilityCode);
		} else {
			return facilityCode;
		}
	}
	
	public int getFacilityObjMapSize() {
		return facilityObjMap.size();
	}
}
