package com.agilex.healthcare.mobilehealthplatform.datalayer.exercise;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class FetchExerciseRequestHandler extends AbstractFetchPatientDataRequestHandler<ExerciseDataLayer, Exercise> {

	@Override
	protected Exercise invokeDataLayerToFetchSingleItem(ExerciseDataLayer datalayer, PatientIdentifier patientIdentifier, String dataId, RequestMessage requestMessage) {
		return datalayer.getExercise(patientIdentifier.getUniqueId(), dataId);
	}

}
