package com.agilex.healthcare.mobilehealthplatform.datalayer.exercise;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Exercise;
import com.agilex.healthcare.mobilehealthplatform.domain.Exercises;

public class FetchExerciseListRequestHandler extends AbstractFetchPatientDataListRequestHandler<ExerciseDataLayer, Exercises, Exercise> {

	@Override
	protected Exercises invokeDataLayerToFetchList(ExerciseDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.getExercises(messageReader.getPatientId(), messageReader.getDateFilter());
	}

}
