package com.agilex.healthcare.mobilehealthplatform.datalayer.exercise;

import java.net.URI;

import com.agilex.healthcare.mobilehealthplatform.utils.QueryParameters;

public class ExerciseFilterFactory {

	public static ExerciseFilter createFilter(URI u) {
		return createFilter(u.getQuery());
	}
	
	private static ExerciseFilter createFilter(String queryString) {
		QueryParameters queryParameters = new QueryParameters(queryString);
		return createFilter(queryParameters);
	}
	
	private static ExerciseFilter createFilter(QueryParameters queryParameters) {
		ExerciseFilter filter = new ExerciseFilter();

		filter.setStartDate(queryParameters.getValueAsDate("startDate"));
		filter.setEndDate(queryParameters.getValueAsDate("endDate"));

		return filter;
	}
}
