package com.agilex.healthcare.mobilehealthplatform.datalayer.exercise;

import com.agilex.healthcare.mobilehealthplatform.datalayer.JournalEventsDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.domain.Exercise;
import com.agilex.healthcare.mobilehealthplatform.domain.Exercises;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.restservice.exception.InvalidExerciseException;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.validator.exercise.ExerciseValidator;

public class ExerciseDataService extends JournalEventsDataService<Exercises, Exercise> {

	public ExerciseDataService() {
		this(new Router());
	}

	public ExerciseDataService(Router router) {
		super(router, Domain.exercise, Exercises.class, new ExerciseValidator());
	}

	@Override
	protected void throwValidationException(ValidationResult<Exercise> validationResult) {
		throw new InvalidExerciseException(validationResult.getErrors());
	}
}
