package com.agilex.healthcare.mobilehealthplatform.datalayer.document;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;

public class FetchDocumentListRequestBuilder extends PatientDataFetchRequestBuilder {

	protected FetchDocumentListRequestBuilder(RequestMessage request) {
		super(request);
	}

	public static FetchDocumentListRequestBuilder forRetrieveList() {
		RequestMessage request = new RequestMessage();
		FetchDocumentListRequestBuilder builder = new FetchDocumentListRequestBuilder(request);
		request.setType("FetchListOfPatientData");
		return builder;
	}

	public static FetchDocumentListRequestBuilder forRetrieveSingleById() {
		RequestMessage request = new RequestMessage();
		FetchDocumentListRequestBuilder builder = new FetchDocumentListRequestBuilder(request);
		request.setType("FetchPatientDataById");
		return builder;
	}

	public FetchDocumentListRequestBuilder forDocumentFilter(DocumentFilter documentFilter) {
		request.setValue("document-filter", documentFilter);
		return this;
	}

}
