package com.agilex.healthcare.mobilehealthplatform.datalayer.document;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Document;
import com.agilex.healthcare.mobilehealthplatform.domain.Documents;

public class FetchDocumentListForPatientRequestHandler extends AbstractFetchPatientDataListRequestHandler<DocumentDataLayer, Documents, Document> {

	@Override
	protected Documents invokeDataLayerToFetchList(DocumentDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		DocumentFetchRequestReader reader = DocumentFetchRequestReader.fromRequest(requestMessage);
		return datalayer.fetchDocuments(reader.getPatientId(), reader.getDocumentFilter());
	}

}
