package com.agilex.healthcare.mobilehealthplatform.datalayer.diet;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class FetchDietRequestHandler extends AbstractFetchPatientDataRequestHandler<DietDataLayer, DietEntry> {

	@Override
	protected DietEntry invokeDataLayerToFetchSingleItem(DietDataLayer datalayer, PatientIdentifier patientIdentifier, String dataId, RequestMessage requestMessage) {
		return datalayer.getDietEntry(patientIdentifier.getUniqueId(), dataId);
	}

}
