package com.agilex.healthcare.mobilehealthplatform.datalayer.diet;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.DietEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.DietEntry;

public class FetchDietListRequestHandler extends AbstractFetchPatientDataListRequestHandler<DietDataLayer, DietEntries, DietEntry> {

	@Override
	protected DietEntries invokeDataLayerToFetchList(DietDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		return datalayer.getDietEntries(messageReader.getPatientId(), messageReader.getDateFilter());
	}

}
