package com.agilex.healthcare.mobilehealthplatform.datalayer.diet;

import com.agilex.healthcare.mobilehealthplatform.datalayer.JournalEventsDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.domain.DietEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.DietEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.ValidationResult;
import com.agilex.healthcare.mobilehealthplatform.restservice.exception.InvalidDietException;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.validator.diet.DietValidator;

public class DietDataService extends JournalEventsDataService<DietEntries, DietEntry> {

	public DietDataService(Router router) {
		super(router, Domain.dietentry, DietEntries.class, new DietValidator()  );
	}

	public DietDataService() {
		this(new Router());
	}

	@Override
	protected void throwValidationException(ValidationResult<DietEntry> validationResult) {
		throw new InvalidDietException(validationResult.getErrors());
	}

}
