package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.securemessage.SecureMessageFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageContacts;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageFolders;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageUser;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessages;

public class SecureMessageRequestReader {
	protected RequestMessage request;
	
	protected SecureMessageRequestReader(RequestMessage request) {
		this.request = request;
	}

	public static SecureMessageRequestReader fromRequest(RequestMessage request) {
		return new SecureMessageRequestReader(request);
	}
	
	public void updateUserIdentifier(PatientIdentifier userIdentifer) {
		request.setValue("user-identifier", userIdentifer);
	}
	
	public String getType() {
		return request.getType();
	}

	public PatientIdentifier getPatientIdentifier() {
		return request.getValue("user-identifier");
	}
	
	public String getPatientId() {
		return getPatientIdentifier().getUniqueId();
	}
	
	public String getDomain() {
		return request.getValue("domain");
	}
	
	public SecureMessage getSecureMessage() {
		return request.getValue("secure-message");
	}
	
	public SecureMessageFilter getSecureMessageFilter() {
		return request.getValue("secure-message-filter");
	}
	
	public SecureMessages getSecureMessages() {
		return request.getValue("secure-messages");
	}
	
	public SecureMessageUser getSecureMessageUser() {
		return request.getValue("secure-message-user");
	}
	
	public SecureMessageFolders getSecureMessageFolders() {
		return request.getValue("secure-message-folders");
	}
	
	public SecureMessageContacts getSecureMessageContacts() {
		return request.getValue("secure-message-contacts");
	}
}
