package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;

public class PatientDataResponseReader<Ts extends PatientDataCollection<T>, T extends PatientData> {

	private ResponseMessage response;

	private PatientDataResponseReader(ResponseMessage request) {
		this.response = request;
	}

	public static <Ts extends PatientDataCollection<T>, T extends PatientData> PatientDataResponseReader<Ts, T> fromResponse(ResponseMessage response) {
		return new PatientDataResponseReader<Ts, T>(response);
	}

	public static PatientDataResponseReader<PatientDataCollection<PatientData>, PatientData> fromResponseWithoutType(ResponseMessage response) {
		return new PatientDataResponseReader<PatientDataCollection<PatientData>, PatientData>(response);
	}

	public Ts getDataList() {
		return response.getValue("data-list");
	}

	public Ts getDataListNoNull(Class<Ts> type) {
		Ts dataList = getDataList();
		if (dataList == null)
			dataList = MhpObjectFactory.initializeByType(type);
		return dataList;
	}

	public int getDataListSize() {
		if (getDataList() == null) {
			return 0;
		} else {
			return getDataList().size();
		}
	}

	public T getDataItem() {
		return response.getValue("data-item");
	}

	public PatientDataFetchRequestReader getRequestReader() {
		return PatientDataFetchRequestReader.fromRequest(response.getRequestMessage());
	}
}
