package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.MhpObjectFactory;

public class PatientDataResponseBuilder {
	private ResponseMessage response;

	private PatientDataResponseBuilder(ResponseMessage response) {
		this.response = response;
	}

	public static PatientDataResponseBuilder newInstance() {
		ResponseMessage response = new ResponseMessage();
		return new PatientDataResponseBuilder(response);
	}

	public static <Ts extends PatientDataCollection<T>, T extends PatientData> PatientDataResponseBuilder fromPatientData(Ts dataList) {
		ResponseMessage response = new ResponseMessage();
		PatientDataResponseBuilder builder = new PatientDataResponseBuilder(response);
		builder.appendPatientData(dataList);
		return builder;
	}

	public static <Ts extends PatientDataCollection<T>, T extends PatientData> PatientDataResponseBuilder fromPatientData(T dataItem) {
		ResponseMessage response = new ResponseMessage();
		PatientDataResponseBuilder builder = new PatientDataResponseBuilder(response);
		builder.setPatientData(dataItem);
		return builder;
	}

	public <Ts extends PatientDataCollection<T>, T extends PatientData> PatientDataResponseBuilder appendPatientData(Ts dataList) {
		if (dataList != null) {

			Ts existingDataList = response.getValue("data-list");
			if (existingDataList == null) {
				// note: the need to create a new collection prevents us from
				// modifying the source collection. In case of caching or
				// in-memory
				// mock this can lead to unindented effects
				@SuppressWarnings("unchecked")
				Ts aggregatedCollection = (Ts) MhpObjectFactory.initializeByType(dataList.getClass());
				aggregatedCollection.addAll(dataList);

				response.setValue("data-list", aggregatedCollection);
			} else {
				existingDataList.addAll(dataList);
			}
		}

		return this;
	}

	public <T extends PatientData> PatientDataResponseBuilder setPatientData(T dataItem) {
		response.setValue("data-item", dataItem);
		return this;
	}

	public ResponseMessage build() {
		return response;
	}

}
