package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientPreference;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.BooleanParser;
import com.agilex.healthcare.utility.NullChecker;

public class PatientDataFetchRequestReader {
	protected RequestMessage request;

	protected PatientDataFetchRequestReader(RequestMessage request) {
		this.request = request;
	}

	public static PatientDataFetchRequestReader fromRequest(RequestMessage request) {
		return new PatientDataFetchRequestReader(request);
	}

	public String getMessageId() {
		return request.getMessageId();
	}

	public String getParentMessageId() {
		return request.getParentId();
	}

	public String getType() {
		return request.getType();
	}

	public PatientIdentifier getPatientIdentifier() {
		return request.getValue("patient-identifier");
	}

	public String getPatientId() {
		return getPatientIdentifier().getUniqueId();
	}

	public DataIdentifier getDataIdentifier() {
		return request.getValue("data-identifier");
	}

	public String getDataId() {
		return getDataIdentifier().getUniqueId();
	}

	public String getDomain() {
		return request.getValue("domain");
	}

	public ScopeFilter getScopeFilter() {
		return request.getValue("scope-filter");
	}

	public DateFilter getDateFilter() {
		return request.getValue("date-filter");
	}

	public boolean shouldIncludeDetails() {
		String value = request.getValue("include-details");
		if (NullChecker.isNullish(value)) {
			return false;
		} else {
			return BooleanParser.parse(value, false);
		}
	}
	
	public PatientPreference getPreference(){
		return request.getValue("preference");
	}

}
