package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DataSystem;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.NullChecker;

public class PatientDataFetchRequestBuilder {
	protected RequestMessage request;

	protected PatientDataFetchRequestBuilder(RequestMessage request) {
		this.request = request;
	}

	public static PatientDataFetchRequestBuilder forRetrieveList() {
		RequestMessage request = new RequestMessage();
		PatientDataFetchRequestBuilder builder = new PatientDataFetchRequestBuilder(request);
		request.setType("FetchListOfPatientData");
		return builder;
	}

	public static PatientDataFetchRequestBuilder forRetrieveSingleById() {
		RequestMessage request = new RequestMessage();
		PatientDataFetchRequestBuilder builder = new PatientDataFetchRequestBuilder(request);
		request.setType("FetchPatientDataById");
		return builder;
	}
	
	public static PatientDataFetchRequestBuilder cloneFromParent(RequestMessage parentRequest) {
		RequestMessage childRequest = parentRequest.createChildCopy();
		return new PatientDataFetchRequestBuilder(childRequest);
	}

	public PatientDataFetchRequestBuilder forType(String type) {
		request.setType(type);
		return this;
	}

	public PatientDataFetchRequestBuilder forPatientIdentifier(PatientIdentifier patientIdentifier) {
		request.setValue("patient-identifier", patientIdentifier);
		return this;
	}

	public PatientDataFetchRequestBuilder forDomain(String domain) {
		request.setValue("domain", domain);
		return this;
	}

	public PatientDataFetchRequestBuilder forScopeFilter(ScopeFilter scopeFilter) {
		request.setValue("scope-filter", scopeFilter);
		return this;
	}

	public PatientDataFetchRequestBuilder forTargetDataSystem(DataSystem dataSystem) {
		ScopeFilter scopeFilter = ScopeFilter.getInstanceForSystem(dataSystem);
		request.setValue("scope-filter", scopeFilter);
		return this;
	}

	public PatientDataFetchRequestBuilder forDataIdentifier(DataIdentifier dataIdentifier) {
		request.setValue("data-identifier", dataIdentifier);
		return this;
	}

	public PatientDataFetchRequestBuilder includeDetails() {
		request.setValue("include-details", "true");
		return this;
	}

	public PatientDataFetchRequestBuilder excludeDetails() {
		request.setValue("include-details", "false");
		return this;
	}

	public RequestMessage build() {
		if (NullChecker.isNullish(request.getMessageId()))
			throw new IllegalArgumentException("ID is a required field");
		if (NullChecker.isNullish(request.getType()))
			throw new IllegalArgumentException("Type is a required field");
		return request;
	}

	public PatientDataFetchRequestBuilder forDateFilter(DateFilter dateFilter) {
		request.setValue("date-filter", dateFilter);
		return this;
	}

	public PatientDataFetchRequestBuilder setValue(String key, String value) {
		request.setValue(key, value);
		return this;
	}

	public PatientDataFetchRequestBuilder setChildMessageType(String childMessageType) {
		request.setValue("childMessageType", childMessageType);
		return this;
	}

}
