package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class PatientDataEditRequestReader<T extends PatientData> {
	private RequestMessage request;

	private PatientDataEditRequestReader(RequestMessage request) {
		this.request = request;
	}

	public static <T extends PatientData> PatientDataEditRequestReader<T> fromRequest(RequestMessage request) {
		return new PatientDataEditRequestReader<T>(request);
	}

	public String getMessageId() {
		return request.getMessageId();
	}

	public String getParentMessageId() {
		return request.getParentId();
	}

	public String getType() {
		return request.getType();
	}

	public String getDomain() {
		return request.getValue("domain");
	}

	public T getData() {
		return request.getValue("data");
	}

	public ScopeFilter getScopeFilter() {
		return request.getValue(MessageFieldKeys.scopefilter);
	}

	public PatientIdentifier getPatientIdentifier() {
		T data = getData();
		PatientIdentifier patientIdentifier;
		if (data == null) {
			patientIdentifier = request.getValue("patient-identifier");
		} else {
			patientIdentifier = data.getPatientIdentifier();
		}

		return patientIdentifier;
	}

	public String getPatientId() {
		return getPatientIdentifier().getUniqueId();
	}

	public DataIdentifier getDataIdentifier() {
		T data = getData();
		DataIdentifier dataIdentifier;
		if (data == null) {
			dataIdentifier = request.getValue("data-identifier");
		} else {
			dataIdentifier = data.getDataIdentifier();
		}

		return dataIdentifier;
	}

	public String getDataId() {
		return getDataIdentifier().getUniqueId();
	}

}
