package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DataSystem;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.NullChecker;

public class PatientDataEditRequestBuilder {
	private RequestMessage request;

	protected PatientDataEditRequestBuilder(RequestMessage request) {
		this.request = request;
	}

	public static PatientDataEditRequestBuilder forCreate() {
		RequestMessage request = new RequestMessage();
		PatientDataEditRequestBuilder builder = new PatientDataEditRequestBuilder(request);
		request.setType("CreatePatientData");
		return builder;
	}

	public static PatientDataEditRequestBuilder forUpdate() {
		RequestMessage request = new RequestMessage();
		PatientDataEditRequestBuilder builder = new PatientDataEditRequestBuilder(request);
		request.setType("UpdatePatientData");
		return builder;
	}

	public static PatientDataEditRequestBuilder forDelete() {
		RequestMessage request = new RequestMessage();
		PatientDataEditRequestBuilder builder = new PatientDataEditRequestBuilder(request);
		request.setType("DeletePatientData");
		return builder;
	}

	public static PatientDataEditRequestBuilder cloneFromParent(RequestMessage parentRequest) {
		RequestMessage childRequest = parentRequest.createChildCopy();
		return new PatientDataEditRequestBuilder(childRequest);
	}

	public PatientDataEditRequestBuilder forType(String type) {
		request.setType(type);
		return this;
	}

	public PatientDataEditRequestBuilder forPatientIdentifier(PatientIdentifier patientIdentifier) {
		if (getData() == null)
			throw new RuntimeException("Must specify data before setting patient identifier");

		PatientData data = getData();
		data.setPatientIdentifier(patientIdentifier);

		return this;
	}

	public PatientDataEditRequestBuilder forDataIdentifier(DataIdentifier dataIdentifier) {
		if (getData() == null)
			throw new RuntimeException("Must specify data before setting data identifier");

		PatientData data = getData();
		data.setDataIdentifier(dataIdentifier);

		return this;
	}

	public PatientDataEditRequestBuilder forDomain(String domain) {
		request.setValue("domain", domain);
		return this;
	}

	public PatientDataEditRequestBuilder forScope(ScopeFilter scopeFilter) {
		request.setValue("scope-filter", scopeFilter);
		return this;
	}

	public PatientDataEditRequestBuilder forTargetDataSystem(DataSystem dataSystem) {
		return forScope(ScopeFilter.getInstanceForSystem(dataSystem));
	}

	public <T extends PatientData> PatientDataEditRequestBuilder forData(T data) {
		request.setValue(MessageFieldKeys.data, data);
		return this;
	}

	private <T> T getData() {
		return request.getValue(MessageFieldKeys.data);
	}

	public RequestMessage build() {
		if (NullChecker.isNullish(request.getMessageId()))
			throw new IllegalArgumentException("ID is a required field");
		if (NullChecker.isNullish(request.getType()))
			throw new IllegalArgumentException("Type is a required field");

		PatientData data = getData();
		if (data == null) {
			throw new IllegalArgumentException("Data is a required field");
		}

		return request;
	}

	public PatientDataEditRequestBuilder setValue(String key, String value) {
		request.setValue(key, value);
		return this;
	}

}
