 package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public class FetchPatientDataByIdRequestHandler implements RequestHandler {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(FetchPatientDataByIdRequestHandler.class);

	public FetchPatientDataByIdRequestHandler() {
	}

	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
//		logger.debug("received request " + requestMessage);

		PatientDataFetchRequestReader messageReader = PatientDataFetchRequestReader.fromRequest(requestMessage);

		// TODO: should this really be a cloned message?
		String childMessageType = messageReader.getDomain() + ".fetch";
		requestMessage.setType(childMessageType);
		
		PatientIdentifier patientIdentifier = messageReader.getPatientIdentifier();
		RequestMessage childRequestMessage = PatientDataFetchRequestBuilder.cloneFromParent(requestMessage).forType(childMessageType).forPatientIdentifier(patientIdentifier).build();

		logger.debug("passing request for patient data to router to be routed to domain specific handler");
		Router router = new Router();
		ResponseMessage response = router.execute(childRequestMessage);
		
		fixPatientIdentifier(response);
		
		logger.debug("complete with execute request message");
		return response;
	}

	private void fixPatientIdentifier(ResponseMessage response) {
		PatientDataResponseReader<?, ?> responseReader = PatientDataResponseReader.fromResponseWithoutType(response);
		PatientData dataItem = responseReader.getDataItem();
		if (dataItem != null) {
			dataItem.setPatientIdentifier(responseReader.getRequestReader().getPatientIdentifier());
			dataItem.getDataIdentifier().setSystemId(responseReader.getRequestReader().getDataIdentifier().getSystemId());
		}
	}
}
