package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;
import com.agilex.healthcare.utility.NullChecker;

public abstract class AbstractSavePatientDataRequestHandler<TDataLayer, T extends PatientData> implements RequestHandler {
	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		PatientDataEditRequestReader<T> messageReader = PatientDataEditRequestReader.fromRequest(requestMessage);
		TDataLayer datalayer = getDataLayer(messageReader);
		T patientData = invokeDataLayerToSaveItem(datalayer, messageReader.getData(), requestMessage);
		return PatientDataResponseBuilder.fromPatientData(patientData).build();
	}

	protected abstract T invokeDataLayerToSaveItem(TDataLayer datalayer, T data, RequestMessage requestMessage);

	private TDataLayer getDataLayer(PatientDataEditRequestReader<T> messageReader) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		TDataLayer datalayer;
		if (NullChecker.isNotNullish(messageReader.getData().getDataIdentifier().getSystemId())) {
			datalayer = serviceRegistry.getDataLayerBySystem(messageReader.getData().getDataIdentifier().getSystemId(), messageReader.getDomain());
		} else {
			datalayer = serviceRegistry.getDataLayerByScopeFilter(messageReader.getScopeFilter(), messageReader.getDomain());
		}
		return datalayer;
	}
}
