package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DomainServiceRegistry;

public abstract class AbstractFetchPatientDataRequestHandler<TDataLayer, T extends PatientData> implements RequestHandler {
	@Override
	public ResponseMessage handle(RequestMessage requestMessage) {
		PatientDataFetchRequestReader messageReader = PatientDataFetchRequestReader.fromRequest(requestMessage);
		TDataLayer datalayer = getDataLayer(requestMessage);
		T patientData = invokeDataLayerToFetchSingleItem(datalayer, messageReader.getPatientIdentifier(), messageReader.getDataIdentifier().getUniqueId(), requestMessage);
		afterFetch(requestMessage, patientData);
		return PatientDataResponseBuilder.fromPatientData(patientData).build();
	}

	protected abstract T invokeDataLayerToFetchSingleItem(TDataLayer datalayer, PatientIdentifier patientIdentifier, String dataId, RequestMessage requestMessage);

	protected void afterFetch(RequestMessage requestMessage, T retrievedPatientData) {
	}

	private TDataLayer getDataLayer(RequestMessage requestMessage) {
		DomainServiceRegistry serviceRegistry = new DomainServiceRegistry();
		return serviceRegistry.getDataLayerByMessage(requestMessage);
	}
}
